/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.ftbutilities;

import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.TeamHandler;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class FTBUtilitiesCompat
implements TeamHandler {
    @Override
    public boolean areOnSameTeam(Owner owner1, Owner owner2) {
        try {
            return FTBLibAPI.arePlayersInSameTeam((UUID)UUID.fromString(owner1.getUUID()), (UUID)UUID.fromString(owner2.getUUID()));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public TeamUtils.TeamRepresentation getTeamRepresentation(Owner owner) {
        if (Universe.loaded()) {
            try {
                ForgePlayer player = Universe.get().getPlayer(UUID.fromString(owner.getUUID()));
                if (player != null && player.team != null && player.team.getMembers().size() > 1) {
                    return new TeamUtils.TeamRepresentation(player.team.getTitle().func_150254_d(), player.team.getColor().getTextFormatting());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Collection<EntityPlayerMP> getOnlinePlayersFromOwner(MinecraftServer server, Owner owner) {
        try {
            ForgePlayer player = Universe.get().getPlayer(UUID.fromString(owner.getUUID()));
            if (player != null && player.team != null) {
                return player.team.getOnlineMembers();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new ArrayList<EntityPlayerMP>();
    }
}

